/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SinksListPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYSKLT";
    private static final String TRACE_MASKF = "XNTYSKLF";
    private static final String TRACE_MASKD = "XNTYSKLD";
    private transient ItemDescriptor[] m_idSinksListTable;
    private transient ColumnDescriptor[] m_cdSinksListTableStructure;
    private int[] m_iSinksListTableSelection;
    private Map data;
    public static final String SINKS_LIST_TABLE = "SinksListTable";
    public static final String TASKLET_SELECTED_SINK = "TaskletSelectedSink";

    public void setSinksListTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iSinksListTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "SinksListPanel");
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setDisposed();
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (this.m_iSinksListTableSelection == null || this.m_iSinksListTableSelection.length == 0) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                Map sinkMap = (Map)this.data.get(SINKS_LIST_TABLE);
                Iterator iterator = sinkMap.keySet().iterator();
                int z = 0;
                while (z < this.m_iSinksListTableSelection[0]) {
                    iterator.next();
                    ++z;
                }
                String mySink = (String)iterator.next();
                request.setData(TASKLET_SELECTED_SINK, mySink);
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (this.m_iSinksListTableSelection == null || this.m_iSinksListTableSelection.length == 0) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                Map sinkMap = (Map)this.data.get(SINKS_LIST_TABLE);
                Iterator iterator = sinkMap.keySet().iterator();
                int z = 0;
                while (z < this.m_iSinksListTableSelection[0]) {
                    iterator.next();
                    ++z;
                }
                String mySink = (String)iterator.next();
                request.setData(TASKLET_SELECTED_SINK, mySink);
            }
        } else if (command.equals(this.getMountPrefix() + "ConfigButton")) {
            request.setData("CommandName", "ConfigButton");
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "<> update()");
        if (newData instanceof Map) {
            Map map = (Map)newData;
            String command = (String)map.get("CommandName");
            Map sinkMap = (Map)this.data.get(SINKS_LIST_TABLE);
            if (command.equals("DeleteButton")) {
                Iterator iterator = sinkMap.keySet().iterator();
                int z = 0;
                while (z <= this.m_iSinksListTableSelection[0]) {
                    iterator.next();
                    ++z;
                }
                iterator.remove();
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + SINKS_LIST_TABLE, new int[0]);
                this.setSinksListTableSelection(new int[0]);
            } else if (command.equals("AddButton")) {
                Map sink = (Map)map.get("AddButton");
                HashMap myMap = new HashMap();
                myMap.put("DataMapSinkName", sink.get("DataMapSinkName"));
                myMap.put("DataMapTemplateName", sink.get("DataMapTemplateName"));
                myMap.put("DataMapSinkDescription", sink.get("DataMapSinkDescription"));
                myMap.put("DataMapUsersTable", sink.get("DataMapUsersTable"));
                myMap.put("DataMapSinkEnabled", sink.get("DataMapSinkEnabled"));
                sinkMap.put((String)sink.get("DataMapSinkName"), myMap);
            } else if (command.equals("EditButton")) {
                Map sink = (Map)map.get("EditButton");
                Iterator iterator = sinkMap.keySet().iterator();
                int z = 0;
                while (z < this.m_iSinksListTableSelection[0]) {
                    iterator.next();
                    ++z;
                }
                String sinkName = (String)iterator.next();
                Map myMap = (Map)sinkMap.get(sinkName);
                myMap.put("DataMapSinkName", sink.get("DataMapSinkName"));
                myMap.put("DataMapTemplateName", sink.get("DataMapTemplateName"));
                myMap.put("DataMapSinkDescription", sink.get("DataMapSinkDescription"));
                myMap.put("DataMapUsersTable", sink.get("DataMapUsersTable"));
                myMap.put("DataMapSinkEnabled", sink.get("DataMapSinkEnabled"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (this.data == null) {
            this.data = new HashMap();
        }
        if (this.data.get(SINKS_LIST_TABLE) == null) {
            this.data.put(SINKS_LIST_TABLE, new TreeMap());
        }
        this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
        this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idSinksListTable = new ItemDescriptor[0];
        this.m_cdSinksListTableStructure = new ColumnDescriptor[0];
        this.m_iSinksListTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getSinksListTableRowCount() {
        Map sinkMap = (Map)this.data.get(SINKS_LIST_TABLE);
        return sinkMap.size();
    }

    public ItemDescriptor[] getSinksListTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "getSinksListTableRowAt(" + index + ")");
        Map sinkMap = (Map)this.data.get(SINKS_LIST_TABLE);
        Iterator iterator = sinkMap.keySet().iterator();
        int z = 0;
        while (z < index) {
            iterator.next();
            ++z;
        }
        String sinkName = (String)iterator.next();
        Trace.trace(TRACE_MASKT, "got sink name");
        Map sink = (Map)sinkMap.get(sinkName);
        ItemDescriptor[] id = new ItemDescriptor[5];
        id[0] = new ItemDescriptor(this.getMountPrefix() + "Name" + index, (String)sink.get("DataMapSinkName"));
        Trace.trace(TRACE_MASKT, "build id0");
        id[1] = new ItemDescriptor(this.getMountPrefix() + "Template" + index, (String)sink.get("DataMapTemplateName"));
        Trace.trace(TRACE_MASKT, "build id1");
        id[2] = new ItemDescriptor(this.getMountPrefix() + "Desc" + index, (String)sink.get("DataMapSinkDescription"));
        Trace.trace(TRACE_MASKT, "build id2");
        String[] users = (String[])sink.get("DataMapUsersTable");
        String userString = "";
        if (users != null) {
            int i = 0;
            while (i < users.length - 1) {
                userString = userString + users[i] + ", ";
                ++i;
            }
            if (users.length > 0) {
                userString = userString + users[users.length - 1];
            }
        }
        id[3] = new ItemDescriptor(this.getMountPrefix() + "Users" + index, userString);
        Trace.trace(TRACE_MASKT, "build id3");
        id[4] = new ItemDescriptor(this.getMountPrefix() + "Status" + index, ((Boolean)sink.get("DataMapSinkEnabled")).toString());
        Trace.trace(TRACE_MASKT, "build id4");
        return id;
    }

    public ColumnDescriptor[] getSinksListTableRowStructure() {
        return this.m_cdSinksListTableStructure;
    }

    public int getSinksListTableRowStatus() {
        return 3;
    }

    public void setSinksListTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSinksListTable = items;
    }

    public int[] getSinksListTableSelection() {
        return this.m_iSinksListTableSelection;
    }
}

